function [Y,P]=interp1Newton(x,y,X,deg)

% INTERP1NEWTON interpolacija Njutnovim interpolacionim polinomom
% Tablica interpolacije mora da sadrzi bar jedan cvor i svi cvorovi moraju biti 
% razliciti
%
% Argumenti funkcije su :
%   x - n-dimenzioni vektor vrsta kojim se zadaju cvorovi interpolacije
%   y - n-dimenzioni vektor vrsta kojim se zadaju vrednosti funkcije u cvorovima
%   X - m-dimenzioni vektor vrsta u kome se zadaju tacke u kojima zelimo izracunatu 
%       vrednost interpolacionog polinoma
%   deg - skalar koji govori da polinom racunamo do stepena deg-1, 
%         ako se ne navede podrazumeva se n
% Funkcija vraca :
%   Y - m-dimenzioni vektor vrednosti interpolacionog polinoma u tackama vektora X


%Provera korektnosti argumenata
if nargin<3
    error('Ocekivana bar 3 argumenta!')
end


[mx,nx]=size(x);
[my,ny]=size(y);
[mX,nX]=size(X);

if (mx~=1 | my~=1 | mX~=1)
    error('Argumenti bi trebalo da su vektori vrste!')
end

n=nx;
if ny~=n
    error('Vektori x i y bi trebalo da budu iste dimenzije')
end

if (~isequal(x,x(finite(x))))
    error('Vrednost svih cvorova bi trebalo da bude konacna')
end

if (~isequal(y,y(finite(y))))
    error('Vrednost funkcije u svim cvorovima bi trebalo da bude konacna')
end


%  pomocni vektor diffs ce da sadrzi jednu po jednu kolonu tablice podeljenih razlika
diffs=y;  % inicijalizujemo ga na vrednosti funkcija u cvorovima

%  vektor diffs_1 sadrzi "gornje" vrednosti tabele podeljenih razlika 
%  diffs_1(i)=f[x1,x2,..,xi]
diffs_1=zeros(1,n);  % prealokacija
diffs_1(1)=y(1); % inicijalizujemo ga na vrednost f(x1)

for i=2:n
    diffs=diff(diffs)./(x(i:n)-x(1:n-i+1)); % diffs postaje sledeca kolona tablice podeljenih razlika
    diffs_1(i)=diffs(1); % diffs_1(i) postavljamo na prvi elemenat vektora k, tj. f[x1,...,xi]
end

% ako nije naveden argument deg ili ako je navedeno da se trazi polinom stepena veceg od n
% izracunavacemo polinom stepena n-1
if (nargin<4 | deg>n) 
    deg=n;
end

%  Prilikom izracunavanja vrednosti polinoma P, koristimo postupak slican hornerovoj semi
%  Inicijalizujemo P na vrednost f[x1,...,xdeg]
P=diffs_1(deg); 
for i=deg-1:-1:1
    %   P=P*(x-xi)+f[x1,...,xi]
    P=conv(P,[1 -x(i)]); 
    P(end)=P(end)+diffs_1(i);  
end
Y=polyval(P,X);
